package app.firezone.synk.network.Fragments;

import android.app.Dialog;
import android.graphics.Color;
import android.graphics.drawable.ColorDrawable;
import android.os.Bundle;

import androidx.fragment.app.Fragment;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import androidx.swiperefreshlayout.widget.SwipeRefreshLayout;

import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;

import app.firezone.synk.network.API.APIClient;
import app.firezone.synk.network.API.MyApi;
import app.firezone.synk.network.API.SharedPrefManager;
import app.firezone.synk.network.Adapter.LudoResultAdapter;
import app.firezone.synk.network.R;
import app.firezone.synk.network.databinding.FragmentFFResultBinding;
import app.firezone.synk.network.model.CheckJoinedResponse;
import app.firezone.synk.network.model.Joined_Match_Model;
import app.firezone.synk.network.model.Match_Model;
import app.firezone.synk.network.model.ResultModel;
import app.firezone.synk.network.model.ResultResponse;
import retrofit2.Call;
import retrofit2.Callback;
import retrofit2.Response;

import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicInteger;


public class FF_Result_Fragment extends Fragment {


    ArrayList<Match_Model> mlist = new ArrayList<>();

    RecyclerView recyclerView;

    FragmentFFResultBinding binding;

    Dialog dialog;

    String gamename;
    LudoResultAdapter myAdapter;

    @Override
    public View onCreateView(LayoutInflater inflater, ViewGroup container,
                             Bundle savedInstanceState) {
        binding = FragmentFFResultBinding.inflate(inflater, container, false);
        View root = binding.getRoot();

        if (getArguments() != null) {
            gamename = getArguments().getString("gamename");
        }

        recyclerView = root.findViewById(R.id.ffResultRecy);
        recyclerView.setLayoutManager(new LinearLayoutManager(getContext()));
        mlist.clear();

        setupDialog();
        fetchMatchResults();


        binding.swipeRefresh.setOnRefreshListener(new SwipeRefreshLayout.OnRefreshListener() {
            @Override
            public void onRefresh() {
                fetchMatchResults();
            }
        });

        return root;

    }

    private void setupDialog() {
        dialog = new Dialog(getContext());
        dialog.setContentView(R.layout.loading_dialog);
        if (dialog.getWindow() != null) {
            dialog.getWindow().setBackgroundDrawable(new ColorDrawable(Color.TRANSPARENT));
            dialog.setCancelable(true);
        }
        dialog.show();
    }

    private void fetchMatchResults() {

        if (!binding.swipeRefresh.isRefreshing()) {
            dialog.show();
        }

        MyApi myApi = APIClient.getApiClient(getContext()).create(MyApi.class);
        Call<ResultResponse> call = myApi.fetchResultMatchData(gamename);

        call.enqueue(new Callback<ResultResponse>() {
            @Override
            public void onResponse(Call<ResultResponse> call, Response<ResultResponse> response) {
                dialog.dismiss();
                binding.swipeRefresh.setRefreshing(false); // Stop swipe animation
                if (response.isSuccessful() && response.body() != null && response.body().isSuccess()) {
                    ArrayList<ResultModel> matches = new ArrayList<>(response.body().getMatches());

                    ArrayList<ResultModel> resultMatches = new ArrayList<>();
                    for (ResultModel match : matches) {
                        if ("Result".equalsIgnoreCase(match.getMatchstatus())) {
                            resultMatches.add(match);
                        }
                    }

                    if (resultMatches.isEmpty()) {
                        // Toast.makeText(getContext(), "No Upcoming Matches Found", Toast.LENGTH_SHORT).show();
                    } else {
                        enrichMatchesWithJoinData(resultMatches);
                    }

                } else {
                    // Toast.makeText(getContext(), "Failed to load match data", Toast.LENGTH_SHORT).show();
                }
            }

            @Override
            public void onFailure(Call<ResultResponse> call, Throwable throwable) {
                binding.swipeRefresh.setRefreshing(false); // Stop swipe animation
            }
        });
    }


    private void enrichMatchesWithJoinData(ArrayList<ResultModel> matchList) {
        long userId = SharedPrefManager.getInstance(getContext()).getUserId();
        MyApi myApi = APIClient.getApiClient(getContext()).create(MyApi.class);

        ArrayList<ResultModel> enrichedList = new ArrayList<>();
        AtomicInteger completedCount = new AtomicInteger(0);
        int totalMatches = matchList.size();

        for (ResultModel originalMatch : matchList) {
            ResultModel match = new ResultModel();
            match.copyFrom(originalMatch);

            AtomicInteger perMatchCount = new AtomicInteger(0);
            match.setMatchCode("not_joined");
            match.setTotalPlayerJoined("0");

            // Fetch join status
            myApi.checkIfUserJoined(userId, match.getId()).enqueue(new Callback<CheckJoinedResponse>() {
                @Override
                public void onResponse(Call<CheckJoinedResponse> call, Response<CheckJoinedResponse> response) {
                    if (response.isSuccessful() && response.body() != null && response.body().isSuccess()) {
                        match.setMatchCode("joined");
                    }

                    if (perMatchCount.incrementAndGet() == 2) {
                        enrichedList.add(match);
                        checkIfAllMatchesProcessed(enrichedList, completedCount, totalMatches);
                    }
                }

                @Override
                public void onFailure(Call<CheckJoinedResponse> call, Throwable t) {
                    if (perMatchCount.incrementAndGet() == 2) {
                        enrichedList.add(match);
                        checkIfAllMatchesProcessed(enrichedList, completedCount, totalMatches);
                    }
                }
            });

            // Fetch joined player count
            myApi.fetchMatchJoinedUsers(match.getId()).enqueue(new Callback<ArrayList<Joined_Match_Model>>() {
                @Override
                public void onResponse(Call<ArrayList<Joined_Match_Model>> call, Response<ArrayList<Joined_Match_Model>> response) {
                    if (response.isSuccessful() && response.body() != null) {
                        match.setTotalPlayerJoined(String.valueOf(response.body().size()));
                    }

                    if (perMatchCount.incrementAndGet() == 2) {
                        enrichedList.add(match);
                        checkIfAllMatchesProcessed(enrichedList, completedCount, totalMatches);
                    }
                }

                @Override
                public void onFailure(Call<ArrayList<Joined_Match_Model>> call, Throwable t) {
                    if (perMatchCount.incrementAndGet() == 2) {
                        enrichedList.add(match);
                        checkIfAllMatchesProcessed(enrichedList, completedCount, totalMatches);
                    }
                }
            });
        }
    }

    private void checkIfAllMatchesProcessed(ArrayList<ResultModel> enrichedList, AtomicInteger completedCount, int totalMatches) {
        if (completedCount.incrementAndGet() == totalMatches) {
            myAdapter = new LudoResultAdapter(enrichedList, getContext());
            recyclerView.setAdapter(myAdapter);
        }
    }



}
